<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Superelevation Data Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis dat klopení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis dat klopení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="RoadwayDesigner">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@fileName"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Section Data -->
                                <xsl:for-each select="SuperelevationSections/SuperelevationSection">
                                    <table class="margin" cellpadding="3" width="90%">
                                        <tbody>
                                            <tr>
                                                <th align="left" lang="en" width = "15%">Název sekce:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" lang="en">Název trasy:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@baseHorizontal"/>
                                                </td>
                                            </tr>
                                            <xsl:if test="Standards">
                                                <tr>
                                                    <th align="left" lang="en">Název souboru směrnic:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@filename"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Návrhová rychlost:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@designSpeed"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Režim otáčení:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@pivotMethod"/>
                                                    </td>
                                                </tr>
                                                <xsl:if test="Standards/@normalCrossSlope">
                                                    <tr>
                                                        <th align="left" lang="en">Sklon střechy:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="cif:gradeFormat(number(Standards/@normalCrossSlope))"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@eSelection">
                                                    <tr>
                                                        <th align="left" lang="en">E výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@eSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@lSelection">
                                                    <tr>
                                                        <th align="left" lang="en">L výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@lSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                            </xsl:if>
                                        </tbody>
                                    </table>
                                    <!-- Superelevation Control Point Data -->
                                    <xsl:choose>
                                        <xsl:when test=".//SuperelevationTransition">
                                            <table class="margin" cellpadding="3" width="95%">
                                                <xsl:for-each select="SuperelevationObjects/SuperelevationObject">
                                                    <tbody>
                                                        <tr>
                                                            <th align="right" colspan="2" lang="en">Klopení:&#xa0; </th>
                                                            <td align="left" colspan="2">
                                                                <xsl:value-of select="@name"/>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                            <th class="underline" lang="en" valign="bottom">Příčný sklon</th>
                                                            <th class="underline" lang="en" valign="bottom">Typ bodu</th>
                                                            <th class="underline" lang="en" valign="bottom">Typ přechodu</th>
                                                        </tr>
                                                        <xsl:for-each select="SuperelevationTransitions/SuperelevationTransition">
                                                            <tr>
                                                                <td align="center" nowrap="nowrap">
                                                                    <strong>
                                                                        <xsl:value-of select="cif:stationFormat(number(@externalStation), string(@externalStationName))"/>
                                                                    </strong>
                                                                </td>
                                                                <td align="center">
                                                                    <xsl:value-of select="cif:gradeFormat(number(@crossSlope))"/>
                                                                </td>
                                                                <xsl:choose>
                                                                    <xsl:when test='@type = "FullSuper"'>
                                                                        <td align="center" lang="en">Plné klopení</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "FullSuperIn"'>
                                                                        <td align="center" lang="en">Plné klopení Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "FullSuperOut"'>
                                                                        <td align="center" lang="en">Plné klopení Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "NormalCrown"'>
                                                                        <td align="center" lang="en">Střecha</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "NormalCrownIn"'>
                                                                        <td align="center" lang="en">Střecha Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "NormalCrownOut"'>
                                                                        <td align="center" lang="en">Střecha Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "ReverseCrown"'>
                                                                        <td align="center" lang="en">Dostředný sklon</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "ReverseCrownIn"'>
                                                                        <td align="center" lang="en">Dostředný sklon Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "ReverseCrownOut"'>
                                                                        <td align="center" lang="en">Dostředný sklon Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "SuperRunoff"'>
                                                                        <td align="center" lang="en">Nulový sklon</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "SuperRunoffIn"'>
                                                                        <td align="center" lang="en">Nulový sklon Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "SuperRunoffOut"'>
                                                                        <td align="center" lang="en">Nulový sklon Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "StartPoint"'>
                                                                        <td align="center" lang="en">Počáteční bod</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "EndPoint"'>
                                                                        <td align="center" lang="en">Koncový bod</td>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <td align="center" lang="en">Nedefinováno</td>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                <xsl:choose>
                                                                    <xsl:when test='preceding-sibling::*'>
                                                                        <xsl:choose>
                                                                            <xsl:when test='@transitionType = "Linear"'>
                                                                                <td align="center" lang="en">Lineární</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "Parabolic"'>
                                                                                <td align="center" lang="en">Parabolický oblouk</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "ReverseParabolic"'>
                                                                                <td align="center" lang="en">Zpětný parabolický oblouk</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "ReverseBiquadratic"'>
                                                                                <td align="center" lang="en">Zpětný biquadratický oblouk</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "ReverseCubic"'>
                                                                                <td align="center" lang="en">Zpětný kubický oblouk</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "ReverseParabolicSymmetrical"'>
                                                                                <td align="center" lang="en">Zpětný parabolický symetrický oblouk</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "ReverseParabolicNonSymmetrical1"'>
                                                                                <td align="center" lang="en">Zpětný parabolický nesymetrický oblouk 1</td>
                                                                            </xsl:when>
                                                                            <xsl:when test='@transitionType = "ReverseParabolicNonSymmetrical2"'>
                                                                                <td align="center" lang="en">Zpětný parabolický nesymetrický oblouk 2</td>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <td align="center" lang="en">Nedefinováno</td>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <td align="center" lang="en"></td>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </tr>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </xsl:for-each>
                                            </table>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <center><p lang="en">Žádné klopení pro výpis.</p></center>
                                        </xsl:otherwise>
                                    </xsl:choose>                                    
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte nejdříve definovat klopení sekce.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu sekci klopení.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>